/* 
 *  Arnold emulator (c) Copyright, Kevin Thacker 1995-2001
 *  
 *  This file is part of the Arnold emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
//#define WIN32_LEAN_AND_MEAN
//#define WIN32_EXTRA_LEAN


//ring buffer, circular buffer
//https://www.gamedev.net/resources/_/technical/directx-and-xna/streaming-wave-files-with-directsound-r710
//http://archive.gamedev.net/archive/reference/articles/article710.html
//https://hackage.haskell.org/package/bindings-portaudio-0.1/src/portaudio/src/hostapi/dsound/pa_win_ds.c
//DSBCAPS_GETCURRENTPOSITION2

//pr continuer si plus focus
//DSBCAPS_GLOBALFOCUS

#include <windows.h>
#include <math.h>

#include "../precomp.h"

#include <mmsystem.h>
#include <dsound.h>
#include <math.h>


#include "ds.h"

void	DS_ClearBuffer();

BOOL SetInfoMessage(char * Message);

BOOL AudioActive = FALSE;
BOOL AudioRunning = FALSE;
static HINSTANCE hModule = NULL;

unsigned long Frequency_corrector = 0;
unsigned long Frequency_corrector_prev = 0;
unsigned long Last_diff1;
unsigned long Last_diff2;

//void	WriteBufferForSoundPlayback(char *pBuffer,int BufferSize);

typedef struct 
{
	GUID		Guid;
	LPSTR		pDescription;
	LPSTR		pModule;
} DIRECT_SOUND_DEVICES_NODE;

static LPDIRECTSOUND	pDirectSound=NULL;

/*
LIST_HEADER			*pDirectSoundDevices=NULL;

HRESULT WINAPI pDirectSoundEnumCallback(GUID FAR *lpGuid, LPSTR lpstrDescription,LPSTR lpstrModule,LPVOID pData)
{
	LIST_HEADER *pList= (LIST_HEADER *)pData;
	DIRECT_SOUND_DEVICES_NODE	*pDirectSoundDeviceNode;

	pDirectSoundDeviceNode = (DIRECT_SOUND_DEVICES_NODE *)malloc(sizeof(DIRECT_SOUND_DEVICES_NODE) + strlen(lpstrDescription) + 1 + strlen(lpstrModule) + 1);
	memcpy(&pDirectSoundDeviceNode->Guid,lpGuid,sizeof(GUID));
	
	pDirectSoundDeviceNode->pDescription = (char *)pDirectSoundDeviceNode + sizeof(DIRECT_SOUND_DEVICES_NODE);
	pDirectSoundDeviceNode->pModule = (char *)pDirectSoundDeviceNode->pModule + strlen(lpstrDescription) + 1;
	memcpy(pDirectSoundDeviceNode->pDescription,lpstrDescription,strlen(lpstrDescription) + 1);
	memcpy(pDirectSoundDeviceNode->pModule,lpstrModule,strlen(lpstrModule) + 1);

	LinkList_AddItemToListEnd(pList,pDirectSoundDeviceNode);

	
	return TRUE;
}
*/

LPDIRECTSOUNDBUFFER pPrimaryBuffer = NULL;
LPDIRECTSOUNDBUFFER pBuffer1 = NULL;

BOOL activebuffer;

//#define BufferSize 16384

unsigned long BufferSize;

WAVEFORMATEX	BufferFormat;

typedef struct	
{
	int Frequency;
	int BitsPerSample;
	int NoOfChannels;
	int Supported;
} SND_FORMAT;

static SND_FORMAT	SoundFormatsTable[16] = 
{
	{8000,8,1,0},
	{8000,8,2,0},
	{8000,16,1,0},
	{8000,16,2,0},
	{11025,8,1,0},
	{11025,8,2,0},
	{11025,16,1,0},
	{11025,16,2,0},
	{22050,8,1,0},
	{22050,8,2,0},
	{22050,16,1,0},
	{22050,16,2,0},
	{44100,8,1,0},
	{44100,8,2,0},
	{44100,16,1,0},
	{44100,16,2,0}
};

#define NUM_SOUND_FORMATS (sizeof(SoundFormatsTable)/sizeof(SND_FORMAT))

void CheckSupportedSoundFormats(LPDIRECTSOUND pDirectSound)
{
	LPDIRECTSOUNDBUFFER pPrimaryBuffer;
	DSBUFFERDESC		DirectSoundBufferDesc;

	if (pDirectSound==NULL)
		return;

	// get primary buffer
	//memset(&DirectSoundBufferDesc, 0, sizeof(DSBUFFERDESC));
	ZeroMemory(&DirectSoundBufferDesc, sizeof(DSBUFFERDESC));

	DirectSoundBufferDesc.dwSize = sizeof(DSBUFFERDESC);
	DirectSoundBufferDesc.dwFlags = DSBCAPS_PRIMARYBUFFER;
	
	// get access to primary buffer
	if (IDirectSound_CreateSoundBuffer(pDirectSound, &DirectSoundBufferDesc, &pPrimaryBuffer, NULL)==DS_OK)
	{
		WAVEFORMATEX	CurrentFormat;
		DWORD				SizeWritten;

		IDirectSoundBuffer_GetFormat(pPrimaryBuffer, &CurrentFormat, sizeof(WAVEFORMATEX), &SizeWritten);

		if (SizeWritten<=sizeof(WAVEFORMATEX))
		{
			int i;

			for (i=0; i<NUM_SOUND_FORMATS; i++)
			{
				WAVEFORMATEX FormatToSet;

				if (IDirectSoundBuffer_SetFormat(pPrimaryBuffer, &FormatToSet)!=DS_OK)
				{
					/* error setting format */

					FormatToSet.wFormatTag = WAVE_FORMAT_PCM;
					FormatToSet.nChannels = SoundFormatsTable[i].NoOfChannels;
					FormatToSet.nSamplesPerSec = SoundFormatsTable[i].Frequency;
					FormatToSet.nBlockAlign = (SoundFormatsTable[i].BitsPerSample>>3) * FormatToSet.nChannels;
					FormatToSet.wBitsPerSample = SoundFormatsTable[i].BitsPerSample;
					FormatToSet.nAvgBytesPerSec = FormatToSet.nBlockAlign*FormatToSet.nSamplesPerSec;
					FormatToSet.cbSize = 0;

					if (IDirectSoundBuffer_SetFormat(pPrimaryBuffer, &FormatToSet)!=DS_OK)
					{

						SoundFormatsTable[i].Supported = FALSE;
					}
					else
					{
						SoundFormatsTable[i].Supported = TRUE;
					}
				}
			}
		}

		/* restore original format */

		IDirectSoundBuffer_SetFormat(pPrimaryBuffer, &CurrentFormat);
	}
}


BOOL DS_Init(HWND hwnd)
{
	DSBUFFERDESC	DirectSoundBufferDesc;

	typedef HRESULT (WINAPI* PFNDIRECTSOUNDCREATE)(LPGUID, LPDIRECTSOUND *, LPUNKNOWN);
	PFNDIRECTSOUNDCREATE pfn;


	AudioActive = FALSE;

	// get direct sound devices
//	DirectSoundEnumerate((LPDSENUMCALLBACK)pDirectSoundEnumCallback,pDirectSoundDevices);

/* TROELS BEGIN */
   if (hModule == NULL) hModule = LoadLibrary(_T("dsound.dll"));
   pfn = (PFNDIRECTSOUNDCREATE)GetProcAddress(hModule, "DirectSoundCreate");
   if (pfn == NULL)
		return FALSE;
	if ((*pfn)(NULL,&pDirectSound,NULL)!=DS_OK)
		return FALSE;
/* TROELS END */   


//	// create a direct sound interface. If this fails, no sound hardware is available
//	if (DirectSoundCreate(NULL,&pDirectSound,NULL)!=DS_OK)
//		return FALSE;

	// initialise normal co-operation level (means that sound device can be shared 
	// with other programs.
	if (IDirectSound_SetCooperativeLevel(pDirectSound,hwnd,DSSCL_PRIORITY)!=DS_OK)	//;	//DSSCL_NORMAL)!=DS_OK)
		return FALSE;

	// get primary buffer
	//memset(&DirectSoundBufferDesc, 0, sizeof(DSBUFFERDESC));
	ZeroMemory(&DirectSoundBufferDesc, sizeof(DSBUFFERDESC));
	DirectSoundBufferDesc.dwSize = sizeof(DSBUFFERDESC);
	DirectSoundBufferDesc.dwFlags = DSBCAPS_PRIMARYBUFFER;
	DirectSoundBufferDesc.dwBufferBytes = 0;     //must be 0 for primary buffer
	DirectSoundBufferDesc.lpwfxFormat = NULL;    //must be null for primary buffer
	
	// get access to primary buffer
	if (IDirectSound_CreateSoundBuffer(pDirectSound, &DirectSoundBufferDesc, &pPrimaryBuffer, NULL)==DS_OK)
	{
		DWORD	SizeWritten;
		WAVEFORMATEX PrimaryBufferFormat;

		// start it playing
		IDirectSoundBuffer_Play(pPrimaryBuffer,0,0,DSBPLAY_LOOPING);

		IDirectSoundBuffer_GetFormat(pPrimaryBuffer, &PrimaryBufferFormat, sizeof(WAVEFORMATEX), &SizeWritten);
		memcpy(&BufferFormat, &PrimaryBufferFormat, sizeof(WAVEFORMATEX));


		{
			WAVEFORMATEX FormatToSet;
			int NoOfChannels = 2;		//1; defaut(2)
			int Frequency = 44100;	//44100;	//22050;	//;44100; defaut(22050)
			int BitsPerSample = 16;	//8;	//16; defaut(8)

			FormatToSet.wFormatTag = WAVE_FORMAT_PCM;
			FormatToSet.nChannels = NoOfChannels;
			FormatToSet.nSamplesPerSec = Frequency;
			FormatToSet.nBlockAlign = (BitsPerSample>>3) * FormatToSet.nChannels;
			FormatToSet.wBitsPerSample = BitsPerSample;
			FormatToSet.nAvgBytesPerSec = FormatToSet.nBlockAlign*FormatToSet.nSamplesPerSec;
			FormatToSet.cbSize = 0;

			IDirectSoundBuffer_SetFormat(pPrimaryBuffer, &FormatToSet);
	
			memcpy(&BufferFormat, &FormatToSet, sizeof(WAVEFORMATEX));
		}

		// release it
		IDirectSoundBuffer_Release(pPrimaryBuffer);

		pPrimaryBuffer = NULL;
	}


//	// initialise buffer formats for secondary buffer
//	BufferFormat.wFormatTag = WAVE_FORMAT_PCM;
//	BufferFormat.nChannels = 1;
//	BufferFormat.nSamplesPerSec = 10000;
//	BufferFormat.nAvgBytesPerSec = 0;
//	BufferFormat.wBitsPerSample = 0;
//	BufferFormat.cbSize = 0;
	
	//10 * 1 sample.
	BufferSize = 5 *(BufferFormat.nSamplesPerSec/50)*((BufferFormat.wBitsPerSample>>3)*BufferFormat.nChannels);


	// create buffer for channel A
	memset(&DirectSoundBufferDesc, 0, sizeof(DSBUFFERDESC));
	DirectSoundBufferDesc.dwSize = sizeof(DSBUFFERDESC);
	DirectSoundBufferDesc.dwFlags = DSBCAPS_GETCURRENTPOSITION2|DSBCAPS_CTRLVOLUME|DSBCAPS_CTRLFREQUENCY ;//| DSBCAPS_CTRLPOSITIONNOTIFY;
	DirectSoundBufferDesc.dwBufferBytes = BufferSize;
	DirectSoundBufferDesc.lpwfxFormat = &BufferFormat;

	
	// channel A buffer
	IDirectSound_CreateSoundBuffer(pDirectSound, &DirectSoundBufferDesc, &pBuffer1, NULL);

	if (pBuffer1 == NULL) return FALSE;

	DS_ClearBuffer();

	//DS_StartSound();

	AudioActive = TRUE;

	return TRUE;
}


void PlayBuffer(unsigned char * buf)
{
//	IDirectSoundBuffer_Play(buf,0,0,DSBPLAY_LOOPING);
}

void DS_StartSound()
{
	if ((pBuffer1!=NULL) && (!AudioRunning))
	{
		IDirectSoundBuffer_Play(pBuffer1,0,0,DSBPLAY_LOOPING);
		AudioRunning = TRUE;
	}
}


int Master_Volume = 100;
void Set_Master_Volume(short vol)
{
	if (vol > 100) vol = 100;
	if (vol < 0) vol = 0;

	Master_Volume = vol;
	DS_SetVolume(Master_Volume);
}

short Get_Master_Volume(void)
{
	return Master_Volume;
}

void DS_SetVolume(int val)
{
	if (pBuffer1!=NULL)
	{
		HRESULT hr;
		long LogVal = 0;
		//convertion deciaml to logaritmic
		if ( val == 0 )
        {
           LogVal = DSBVOLUME_MIN;
        }
        else
        {
            LogVal = (int)floorf( 2000.0f * log10f( (float)(val) / (float)100 ) + 0.5f );
        }

		hr = IDirectSoundBuffer_SetVolume(pBuffer1,LogVal);

	}
}


void DS_StopSound()
{
	if ((pBuffer1!=NULL) && (AudioRunning))
	{
//		HRESULT hr;
//		hr = IDirectSoundBuffer_SetVolume(pPrimaryBuffer,DSBVOLUME_MIN);
		//DS_ClearBuffer();
		IDirectSoundBuffer_Stop(pBuffer1);
		AudioRunning = FALSE;
	}
}


void	FinishDirectSound()
{
	if (pBuffer1!=NULL)
	{
		IDirectSoundBuffer_Stop(pBuffer1);
		IDirectSoundBuffer_Release(pBuffer1);
		pBuffer1 = NULL;
	}

	if (pPrimaryBuffer!=NULL)
	{
		IDirectSoundBuffer_Release(pPrimaryBuffer);
		pPrimaryBuffer = NULL;
	}

	if (pDirectSound!=NULL)
	{
		IDirectSound_Release(pDirectSound);
	}
}

void	DS_Close()
{
	FinishDirectSound();
}


static unsigned char *pAudioBufferPtr1;
static unsigned char *pAudioBufferPtr2;
static unsigned long AudioBufferBlock1Size;
static unsigned long AudioBufferBlock2Size;

//static unsigned long BufferIndex = 0;
//static unsigned long BufferPositions[100];
static unsigned long PrevPos = 0;

#if 0
DWORD GetMaxWriteSize (void)
{
	unsigned long playpos, writepos;
	unsigned long MaxSize;
	
	if (IDirectSoundBuffer_GetCurrentPosition(pBuffer1, &playpos, &writepos)==DS_OK)
	{
		
		if (PrevPos<=playpos)
		{
			MaxSize = playpos - PrevPos;
		}
		else
		{
			MaxSize = BufferSize - PrevPos + playpos;
		}

	}
	else
	{
		MaxSize = 0;
	}

	return MaxSize;
}
#endif

DWORD GetCursorSizeBetween (DWORD c1,DWORD c2)
{
	if (c1<=c2)
	{
		return c2 - c1;
	}
	else
	{
		return BufferSize - c1 + c2;
	}
}


/*

    For directSound
	Write cursor is just like the Prev cursor but more securised



	For my test 
	Buffer for 1 loop is = (44100 / 50)*((16 >> 3) * 2) = 3528
	Buffersize = 3528 * 4 ( 1 buff for play + 1 buff for write + 2 buff security)
	Why 2 ? Because If we start at play buffer, add 3528 already in memory 
	f = 3528 / (2 * 2 ) *  50



	To get size
	|++++++++Play-----------Prev+++++++++++|
	|---------Prev+++++++++++++Play--------|
	++++ Safe zone = MaxSize




	To check error
	|---------Play+++++++++++++Prev--------|
	|++++++++Prev-----------Play+++++++++++|
	++++ = difsize1. Check if play go too fast

	|++++++++Play-----------Prev+++++++++++|
	|---------Prev+++++++++++++Play--------|
	++++ = difsize2 . check if play is not enought far away = space between prev and play too small  = BuffSize > MaxSize

	From my test
	In the better case difsize2  = smaller possible
	Crakle if difsize2 > difsize1 so when difsize2 > Buffersize/2

	I can't explain why but 
	if we write above the play cursor but just after > no problem
	if we write above the play cursor but just before > crakle
	



	//IDirectSoundBuffer_SetCurrentPosition(pBuffer1, pos);

*/
BOOL DS_LockAudioBuffer2(unsigned char **ppBuffer, unsigned long *pBuf1Size, unsigned char **ppBuffer2, unsigned long *pBuf2Size, unsigned long BuffSize)
{
	unsigned long playpos, writepos;
	HRESULT hr;
	unsigned long MaxSize;

	int error = 0;
	unsigned long difsize1;
	unsigned long difsize2;

	//unsigned long diff;


	*ppBuffer = NULL;
	*ppBuffer2 = NULL;
	*pBuf1Size = 0;
	*pBuf2Size = 0;

	
	//For here all, tuto say to use PrevPos, but not working for me, need to use writepos (who is just an indication from directX)
	if (IDirectSoundBuffer_GetCurrentPosition(pBuffer1, &playpos, &writepos)==DS_OK)
	{
		//unsigned long MaxSize2;
		//unsigned long pos;


		MaxSize = GetCursorSizeBetween(PrevPos,playpos);
#if 0
		//this part is only for directSound, I can't explain why but write cursor is more secure than prev one.
		MaxSize2 = GetCursorSizeBetween(writepos,playpos);
		if (MaxSize > MaxSize2)
		{
			MaxSize = MaxSize2;
		}
#endif

	}
	else
	{
		MaxSize = 0;
	}

	//Check if play go faster
	difsize1 = GetCursorSizeBetween(playpos,PrevPos);

	//check if play is not enought far away = space between prev and play too small  = BuffSize > MaxSize
	difsize2 = GetCursorSizeBetween(PrevPos,playpos);

	//if difsize2 < 1000 no problem
	//problem if buf2 > buf1



#if 0

		if (difsize1 < 6000 )
		{
			error = 1;
			//only make modif if previous don't works
			if ( Last_diff1 <= difsize1)
			{
				unsigned long f = BufferFormat.nSamplesPerSec;
				Frequency_corrector = Frequency_corrector - 1;

				hr = IDirectSoundBuffer_SetFrequency(pBuffer1,f + Frequency_corrector);
			}
		}
		//else if ((difsize2 < 3528) && ( Last_diff2 <= difsize2))
		//In fact the buffer is already in memory so we can write under the play cursor, but crackle if this one > total buffer/2
		else if (MaxSize < 4000)
		{
			error = 2;
			//only make modif if previous don't works
			if  (Last_diff2 >= difsize2)
			{
				unsigned long f = BufferFormat.nSamplesPerSec;
				Frequency_corrector = Frequency_corrector + 1;

				hr = IDirectSoundBuffer_SetFrequency(pBuffer1,f + Frequency_corrector);
			}
		}
		else
		{
			unsigned long f = BufferFormat.nSamplesPerSec;
			Frequency_corrector =  BuffSize / ((BufferFormat.wBitsPerSample/8) * BufferFormat.nChannels ) *  50 - f;

			hr = IDirectSoundBuffer_SetFrequency(pBuffer1,f + Frequency_corrector);
			error = 0;
		}

		Last_diff1 = difsize1;
		Last_diff2 = difsize2;
#endif

#if 0
	{
		//Works
		unsigned long f = BufferFormat.nSamplesPerSec;
		Frequency_corrector =  BuffSize / ((BufferFormat.wBitsPerSample/8) * BufferFormat.nChannels ) *  50 - f;
			

		hr = IDirectSoundBuffer_SetFrequency(pBuffer1,f + Frequency_corrector);
	}

		//replace the cursor at good place because synchronisation take time.
		if (difsize2 > 5000)
		{
			unsigned long f;
			f = playpos + 1000;
			if (f > BufferSize)  f -= BufferSize;
			hr = IDirectSoundBuffer_SetCurrentPosition(pBuffer1, f);
		}
#endif

#if 0
		//Synchronisation part
		if ((difsize2>4000) && (Frequency_corrector_prev < difsize2))
		{
			unsigned long f = BufferFormat.nSamplesPerSec;
			Frequency_corrector = Frequency_corrector - 1;

			hr = IDirectSoundBuffer_SetFrequency(pBuffer1,f + Frequency_corrector);
		}
		if ((difsize2<3500) && (Frequency_corrector_prev > difsize2))
		{
			unsigned long f = BufferFormat.nSamplesPerSec;
			Frequency_corrector = Frequency_corrector + 1;

			hr = IDirectSoundBuffer_SetFrequency(pBuffer1,f + Frequency_corrector);
		}
		Frequency_corrector_prev = difsize2;

		//replace the cursor at good place because synchronisation take time.
		if (difsize2 > 5000)
		{
			unsigned long f;
			f = playpos + 1000;
			if (f > BufferSize)  f -= BufferSize;
			hr = IDirectSoundBuffer_SetCurrentPosition(pBuffer1, f);
		}

#endif

#if 0
		{
			signed long d = difsize2 - Frequency_corrector_prev;
			if (d > 0)
			{
				unsigned long f = BufferFormat.nSamplesPerSec;
				Frequency_corrector = Frequency_corrector - 1;

				hr = IDirectSoundBuffer_SetFrequency(pBuffer1,f + Frequency_corrector);
			}
			if (d < 0 )
			{

				unsigned long f = BufferFormat.nSamplesPerSec;
				Frequency_corrector = Frequency_corrector + 1;

				hr = IDirectSoundBuffer_SetFrequency(pBuffer1,f + Frequency_corrector);

			}

			Frequency_corrector_prev = difsize2;

		//replace the cursor at good place because synchronisation take time.
		if (difsize2 > 5000)
		{
			unsigned long f;
			f = playpos + 1000;
			if (f > BufferSize)  f -= BufferSize;
			//hr = IDirectSoundBuffer_SetCurrentPosition(pBuffer1, f);
		}

		}

#endif

#if 0
	{
		char tmp[256];
		wsprintf(tmp,"Cor : %i buf1: %i buf2: %i buffsize: %i Maxsize: %i Freq: %i",error,difsize1,difsize2,BuffSize,MaxSize,BufferFormat.nSamplesPerSec+ Frequency_corrector);
		SetInfoMessage(tmp);

	}
#endif

	//hr = IDirectSoundBuffer_Lock(pBuffer1, 0, BuffSize, (LPVOID*)ppBuffer, pBuf1Size, (LPVOID*)ppBuffer2, pBuf2Size, DSBLOCK_FROMWRITECURSOR);
	hr = IDirectSoundBuffer_Lock(pBuffer1, PrevPos, BuffSize, (LPVOID*)ppBuffer, pBuf1Size, (LPVOID*)ppBuffer2, pBuf2Size,NULL);

	if (hr == DSERR_BUFFERLOST)
	{
		IDirectSoundBuffer_Restore(pBuffer1);
		//hr = IDirectSoundBuffer_Lock(pBuffer1, 0, BuffSize, (LPVOID*)ppBuffer, pBuf1Size, (LPVOID*)ppBuffer2, pBuf2Size, DSBLOCK_FROMWRITECURSOR);
		hr = IDirectSoundBuffer_Lock(pBuffer1, PrevPos, BuffSize, (LPVOID*)ppBuffer, pBuf1Size, (LPVOID*)ppBuffer2, pBuf2Size,NULL);
	}


	if (hr == DS_OK)
	{
		pAudioBufferPtr1 = *ppBuffer;
		pAudioBufferPtr2 = *ppBuffer2;
		AudioBufferBlock1Size = *pBuf1Size;
		AudioBufferBlock2Size = *pBuf2Size;

		if (AudioBufferBlock2Size > 0)
		{
			PrevPos = AudioBufferBlock2Size;
		}
		else
		{
			PrevPos = PrevPos + AudioBufferBlock1Size;
		}
		//PrevPos = (PrevPos + AudioBufferBlock1Size + AudioBufferBlock2Size) % BufferSize;
		//PrevPos = PrevPos + AudioBufferBlock1Size + AudioBufferBlock2Size;

		if	(PrevPos >= BufferSize)
		{
			PrevPos -= BufferSize;
		}


		return TRUE;
	}

	return FALSE;
}


BOOL DS_LockAudioBuffer(unsigned char **ppBuffer, unsigned long *pBuf1Size, unsigned char **ppBuffer2, unsigned long *pBuf2Size, unsigned long BuffSize)
{
	unsigned long playpos, writepos;
	HRESULT hr;
	unsigned long MaxSize;

	int error = 0;
	unsigned long difsize1;
	unsigned long difsize2;

	//unsigned long diff;


	*ppBuffer = NULL;
	*ppBuffer2 = NULL;
	*pBuf1Size = 0;
	*pBuf2Size = 0;

	
	//For here all, tuto say to use PrevPos, but not working for me, need to use writepos (who is just an indication from directX)
	if (IDirectSoundBuffer_GetCurrentPosition(pBuffer1, &playpos, &writepos)==DS_OK)
	{
		//unsigned long MaxSize2;
		//unsigned long pos;

		MaxSize = GetCursorSizeBetween(PrevPos,playpos);
	}
	else
	{
		MaxSize = 0;
	}

	//Check if play go faster
	difsize1 = GetCursorSizeBetween(playpos,PrevPos);

	//check if play is not enought far away = space between prev and play too small  = BuffSize > MaxSize
	difsize2 = GetCursorSizeBetween(PrevPos,playpos);

	//error check, on directX MaxSize can be < BuffSize without problem ???
	if (difsize1 < 5000)
		return FALSE;


	// ca passera pas
	if (BuffSize > MaxSize)
	{
		//Tant pis pour le sond faut resynchro
		DWORD p;
		p = PrevPos - MaxSize;
		if (p < 0) { p = BufferSize + p; }

		IDirectSoundBuffer_SetCurrentPosition(pBuffer1,p);
	}

#if 0
	{
		char tmp[256];
		wsprintf(tmp,"play>prev: %i Prev>play: %i buffsize: %i Maxsize: %i Freq: %i",difsize1,difsize2,BuffSize,MaxSize,BufferFormat.nSamplesPerSec+ Frequency_corrector);
		SetInfoMessage(tmp);

	}
#endif

#if 0
	{
		unsigned long f = BufferFormat.nSamplesPerSec;
		Frequency_corrector =  BuffSize / ((BufferFormat.wBitsPerSample/8) * BufferFormat.nChannels ) *  50 - f;

		hr = IDirectSoundBuffer_SetFrequency(pBuffer1,f + Frequency_corrector);
		error = 0;
	}
#endif

	//hr = IDirectSoundBuffer_Lock(pBuffer1, 0, BuffSize, (LPVOID*)ppBuffer, pBuf1Size, (LPVOID*)ppBuffer2, pBuf2Size, DSBLOCK_FROMWRITECURSOR);
	hr = IDirectSoundBuffer_Lock(pBuffer1, PrevPos, BuffSize, (LPVOID*)ppBuffer, pBuf1Size, (LPVOID*)ppBuffer2, pBuf2Size,NULL);

	if (hr == DSERR_BUFFERLOST)
	{
		IDirectSoundBuffer_Restore(pBuffer1);
		//hr = IDirectSoundBuffer_Lock(pBuffer1, 0, BuffSize, (LPVOID*)ppBuffer, pBuf1Size, (LPVOID*)ppBuffer2, pBuf2Size, DSBLOCK_FROMWRITECURSOR);
		hr = IDirectSoundBuffer_Lock(pBuffer1, PrevPos, BuffSize, (LPVOID*)ppBuffer, pBuf1Size, (LPVOID*)ppBuffer2, pBuf2Size,NULL);
	}


	if (hr == DS_OK)
	{
		pAudioBufferPtr1 = *ppBuffer;
		pAudioBufferPtr2 = *ppBuffer2;
		AudioBufferBlock1Size = *pBuf1Size;
		AudioBufferBlock2Size = *pBuf2Size;

		if (AudioBufferBlock2Size > 0)
		{
			PrevPos = AudioBufferBlock2Size;
		}
		else
		{
			PrevPos = PrevPos + AudioBufferBlock1Size;
		}
		//PrevPos = (PrevPos + AudioBufferBlock1Size + AudioBufferBlock2Size) % BufferSize;
		//PrevPos = PrevPos + AudioBufferBlock1Size + AudioBufferBlock2Size;

		if	(PrevPos >= BufferSize)
		{
			PrevPos -= BufferSize;
		}


		return TRUE;
	}

	return FALSE;
}


void	DS_UnLockAudioBuffer()
{

	//memcpy( pAudioBufferPtr1 , buffer , AudioBufferBlock1Size );
	//memcpy( pAudioBufferPtr2 , buffer +  AudioBufferBlock1Size, AudioBufferBlock2Size );

	/* unlock the buffer */
	IDirectSoundBuffer_Unlock(pBuffer1, pAudioBufferPtr1, AudioBufferBlock1Size, pAudioBufferPtr2, AudioBufferBlock2Size);
}


BOOL	DS_AudioActive()
{
	return AudioActive;
}

int	DS_GetSampleRate()
{
	return BufferFormat.nSamplesPerSec;
}

int	DS_GetSampleBits()
{
	return BufferFormat.wBitsPerSample;
}


int	DS_GetSampleChannels()
{
	return BufferFormat.nChannels;
}


void DS_ClearBuffer()
{
	DSBCAPS	BufferCaps;

	if (pBuffer1!=NULL)
	{

		BufferCaps.dwSize = sizeof(DSBCAPS);

		// channel A buffer
		if (IDirectSoundBuffer_GetCaps(pBuffer1, &BufferCaps)==DS_OK)
		{
			void *pAudioPtr1, *pAudioPtr2;
			unsigned long	AudioBytes1, AudioBytes2;
			
			//TODO : Check values
			int silence = 0x000;
		
			/* lock the buffer */
			if (IDirectSoundBuffer_Lock(pBuffer1, 0, BufferCaps.dwBufferBytes,&pAudioPtr1, &AudioBytes1,&pAudioPtr2, &AudioBytes2, 0)==DS_OK)
			{
				if (pAudioPtr1!=NULL)
				{
					memset(pAudioPtr1, silence, AudioBytes1);
				}

				if (pAudioPtr2!=NULL)
				{
					memset(pAudioPtr2, silence, AudioBytes2);
				}


				IDirectSoundBuffer_Unlock(pBuffer1, pAudioPtr1, AudioBytes1, pAudioPtr2, AudioBytes2);
			}
			//else {
			//	IDirectSoundBuffer_Restore(pBuffer1);//droopy
			//}
		}
	}
}


void Debugsound(void)
{
	DS_ClearBuffer();
}